/* Copyright 2010 Ian George - http://www.iangeorge.net

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/


var HEX=new Array("0","1","2","3","4","5","6","7","8","9","a","b","c","d","e","f");function mqueue(size,negate){this.items=new Array();this.size=size;this.last=0;this.reset=function(){this.items=new Array();};this.add=function(abs_val){var val=0;if(negate){abs_val*=-1;}
if(this.last==0)this.last=abs_val;val=abs_val-this.last;this.last=abs_val;this.items.push(val);if(this.items.length>this.size){this.items.shift();}};this.avg=function(){var total=0;var rv=0;if(this.items.length>1){for(i in this.items){total+=this.items[i];}
rv=(total/size);}
return rv;};}
(function($){$.fn.tagcloud=function(options){var opts=$.extend($.fn.tagcloud.defaults,options);opts.drawing_interval=1/(opts.fps/1000);$(this).each(function(){new TagCloudClass($(this),opts);});return this;};$.fn.tagcloud.defaults={zoom:90,max_zoom:120,min_zoom:25,zoom_factor:5,rotate_factor:2,fps:20,centrex:250,centrey:250,min_font_size:12,max_font_size:32,font_units:'px',random_points:0,init_motion_x:0,init_motion_y:0,decay:0.90};var TagCloudClass=function(el,options){$(el).css('position','relative');var eyez=-500;var rad=Math.PI/180;var global_cos=Math.cos(0);var dirty=true;var container=$(el);var id_stub='tc_'+$(el).attr('id')+"_";var opts=options;var zoom=opts.zoom;var depth;var points_meta=[];var points_data=[];var vectorx=opts.init_motion_x;var vectory=opts.init_motion_y;var motionx=new mqueue(50,true);var motiony=new mqueue(50,false);var dragging=false;var clicked=false;var mousex=0;var mousey=0;var drawing_interval;var cmx=options.centrex;var cmy=options.centrey;var bg_colour;if(options.background_colour){bg_colour=parsecolour(options.background_colour);}else{bg_colour=parsecolour($(el).css('background-color'));}
function parsecolour(colour){function parse_rgb_colour(colour){rgb=colour.match(/^rgb\((\d+),\s*(\d+),\s*(\d+)\)$/);if(!rgb)return{"r":255,"g":255,"b":255};if(rgb.length>3){return{"r":parseInt(rgb[1]),"g":parseInt(rgb[2]),"b":parseInt(rgb[3])};}else{return{"r":0,"g":0,"b":0};}}
function parse_hex_colour(colour){var r=0,g=0,b=0;if(colour.length>4)
{r=parseInt(colour.substr(1,2),16);g=parseInt(colour.substr(3,2),16);b=parseInt(colour.substr(5,2),16);}
else
{r=parseInt(colour.substr(1,1)+colour.substr(1,1),16);g=parseInt(colour.substr(2,1)+colour.substr(2,1),16);b=parseInt(colour.substr(3,1)+colour.substr(3,1),16);}
return{"r":r,"g":g,"b":b};}
if(colour.substr(0,1)==='#')
{return parse_hex_colour(colour);}
else if(colour.substr(0,3)==='rgb')
{return parse_rgb_colour(colour);}
else{if(window.console!=undefined)
console.log("unable to parse:'"+colour+"' please ensure background and foreground colors for the container are set as hex values");return null;}}
function getcolour(num,fg_colour){if(num>256){num=256;}
if(num<0){num=0;}
var r=getshade(bg_colour.r,fg_colour.r,num);var g=getshade(bg_colour.g,fg_colour.g,num);var b=getshade(bg_colour.b,fg_colour.b,num);var ret="rgb("+r+", "+g+", "+b+")";return ret;}
function getshade(lbound,ubound,dist){var scope=ubound-lbound;var dist_percent=scope/100;var shade=Math.round(lbound+(dist*dist_percent));return shade;}
function zoomed(by){zoom+=by*opts.zoom_factor;if(zoom>opts.max_zoom){zoom=opts.max_zoom;}
if(zoom<opts.min_zoom){zoom=opts.min_zoom;}
depth=-(zoom*(eyez-opts.max_zoom)/100)+eyez;dirty=true;}
function decay_me(vector){if(Math.abs(vector)<0.5){vector=0;}else{if(vector>0){vector*=opts.decay;}
if(vector<0){vector*=opts.decay;}}
return vector;}
function move(){if(vectorx!=0||vectory!=0){var factor=options.rotate_factor;var tx=vectorx*rad*factor;var ty=vectory*rad*factor;for(var p in points_data)
{var sin_x=Math.sin(tx);var cos_x=Math.cos(tx);var sin_y=Math.sin(ty);var cos_y=Math.cos(ty);var x=points_data[p].x;var z=points_data[p].z;points_data[p].x=x*cos_x+z*sin_x;points_data[p].z=z*cos_x-x*sin_x;var y=points_data[p].y;var z=points_data[p].z;points_data[p].y=y*cos_y-z*sin_y;points_data[p].z=y*sin_y+z*cos_y;}
dirty=true;}}
function decay_all(){vectorx=decay_me(vectorx);vectory=decay_me(vectory);if(!dragging){motionx.add(0);motiony.add(0);}}
function draw(){if(dirty){var smallz=10000;var bigz=-10000;for(var r_p in points_data){if(points_data[r_p].z<smallz){smallz=points_data[r_p].z;}
if(points_data[r_p].z>bigz){bigz=points_data[r_p].z;}}
var minz=Math.min(smallz,bigz);var maxz=Math.max(smallz,bigz);var diffz=maxz-minz;for(var s_p in points_data){var u=(depth-eyez)/(points_data[s_p].z-eyez);var dist=Math.round(((maxz-points_data[s_p].z)/diffz)*100);var dist_colour=getcolour(dist,points_data[s_p].colour);points_data[s_p].element.css('color',dist_colour);points_data[s_p].element.css('z-index',dist);points_data[s_p].element.css('left',u*points_data[s_p].x+cmx-points_data[s_p].cwidth);points_data[s_p].element.css('top',u*points_data[s_p].y+cmy);}
dirty=false;}
move(vectorx,vectory);decay_all();}
function debug(msg){$("#debug").append('<p>'+msg+'</p>');}
points_meta.count=$('li a',container).length;points_meta.largest=1;points_meta.smallest=0;$('li a',container).each(function(idx,val){var sz=parseInt($(this).attr('rel'));if(sz==0)
sz=1;var point_id=id_stub+idx;points_data[idx]={size:sz};var h=-1+2*(idx)/(points_meta.count-1);points_data[idx].theta=Math.acos(h);if(idx==0||idx==points_meta.count-1){points_data[idx].phi=0;}
else{points_data[idx].phi=(points_data[idx-1].phi+3.6/Math.sqrt(points_meta.count*(1-Math.pow(h,2))))%(2*Math.PI);}
points_data[idx].x=Math.cos(points_data[idx].phi)*Math.sin(points_data[idx].theta)*(cmx/2);points_data[idx].y=Math.sin(points_data[idx].phi)*Math.sin(points_data[idx].theta)*(cmy/2);points_data[idx].z=Math.cos(points_data[idx].theta)*(cmx/2);points_data[idx].colour=parsecolour($(this).css('color'));if(sz>points_meta.largest)points_meta.largest=sz;if(sz<points_meta.smallest)points_meta.smallest=sz;$(this).css('position','absolute');$(this).addClass('point');$(this).attr('id',point_id);points_data[idx].element=$('#'+point_id);});var sz_range=points_meta.largest-points_meta.smallest+1;var sz_n_range=opts.max_font_size-opts.min_font_size+1;for(var p in points_data){var sz=points_data[p].size;var sz_n=parseInt((sz/sz_range)*sz_n_range)+opts.min_font_size;if(!points_data[p].element.hasClass('background')){points_data[p].element.css('font-size',sz_n);}
points_data[p].cwidth=points_data[p].element.width()/2;}
depth=-(zoom*(eyez-opts.max_zoom)/100)+eyez;draw();drawing_interval=setInterval(draw,opts.drawing_interval);container.bind('touchstart',function(evt){clicked=true;motionx.reset();motiony.reset();vectorx=0;vectory=0;},false);container.bind('touchmove',function(evt){if(clicked)dragging=true;if(dragging){motionx.add(evt.pageX);motiony.add(evt.pageY);vectorx=motionx.avg();vectory=motiony.avg();}
evt.preventDefault();},false);container.bind('touchend',function(evt){clicked=false;dragging=false;motionx.reset();motiony.reset();},false);container.mousedown(function(evt){if(evt.which==1){clicked=true;motionx.reset();motiony.reset();vectorx=0;vectory=0;}
evt.preventDefault();return false;});container.mousemove(function(evt){if(clicked)dragging=true;if(dragging){motionx.add(evt.pageX);motiony.add(evt.pageY);vectorx=motionx.avg();vectory=motiony.avg();}
evt.preventDefault();});container.mouseup(function(evt){if(evt.which==1){clicked=false;dragging=false;motionx.reset();motiony.reset();}});container.mouseleave(function(evt){dragging=false;clicked=false;motionx.reset();motiony.reset();});container.mousewheel(function(evt,delta){zoomed(delta);evt.preventDefault();return false;});};})(jQuery);